/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.info.ActionLimitation;
import com.alrex.parcool.common.info.LimitationByServer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class LimitationByServerMessage {
    private boolean forIndividuals = false;
    private boolean enforced = false;
    private int maxStaminaLimitation = Integer.MAX_VALUE;
    private int maxStaminaRecovery = Integer.MAX_VALUE;
    private boolean permissionOfInfiniteStamina = true;
    private final ActionLimitation[] limitations = new ActionLimitation[ActionList.ACTIONS.size()];

    public void setEnforced(boolean enforced) {
        this.enforced = enforced;
    }

    public void setMaxStaminaLimitation(int maxStaminaLimitation) {
        this.maxStaminaLimitation = maxStaminaLimitation;
    }

    public void setPermissionOfInfiniteStamina(boolean permissionOfInfiniteStamina) {
        this.permissionOfInfiniteStamina = permissionOfInfiniteStamina;
    }

    public void setMaxStaminaRecovery(int maxStaminaRecovery) {
        this.maxStaminaRecovery = maxStaminaRecovery;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    public ActionLimitation[] getLimitations() {
        return this.limitations;
    }

    public int getMaxStaminaLimitation() {
        return this.maxStaminaLimitation;
    }

    public int getMaxStaminaRecovery() {
        return this.maxStaminaRecovery;
    }

    public boolean getPermissionOfInfiniteStamina() {
        return this.permissionOfInfiniteStamina;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.forIndividuals);
        packet.writeBoolean(this.enforced);
        packet.writeInt(this.maxStaminaLimitation);
        packet.writeInt(this.maxStaminaRecovery);
        packet.writeBoolean(this.permissionOfInfiniteStamina);
        for (ActionLimitation limitation : this.limitations) {
            packet.writeBoolean(limitation.isPossible()).writeInt(limitation.getLeastStaminaConsumption());
        }
    }

    public static LimitationByServerMessage decode(FriendlyByteBuf packet) {
        LimitationByServerMessage message = new LimitationByServerMessage();
        message.forIndividuals = packet.readBoolean();
        message.enforced = packet.readBoolean();
        message.maxStaminaLimitation = packet.readInt();
        message.maxStaminaRecovery = packet.readInt();
        message.permissionOfInfiniteStamina = packet.readBoolean();
        for (int i = 0; i < ActionList.ACTIONS.size(); ++i) {
            message.limitations[i] = new ActionLimitation(packet.readBoolean(), packet.readInt());
        }
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (this.forIndividuals) {
                parkourability.getActionInfo().receiveIndividualLimitation(this);
            } else {
                parkourability.getActionInfo().receiveLimitation(this);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private static LimitationByServerMessage newInstanceForServerWide() {
        LimitationByServerMessage message = new LimitationByServerMessage();
        ParCoolConfig.Server config = ParCoolConfig.CONFIG_SERVER;
        message.maxStaminaLimitation = (Integer)config.staminaMax.get();
        message.enforced = (Boolean)ParCoolConfig.CONFIG_SERVER.enforced.get();
        message.permissionOfInfiniteStamina = (Boolean)config.allowInfiniteStamina.get();
        message.maxStaminaRecovery = (Integer)config.staminaRecoveryMax.get();
        message.forIndividuals = false;
        for (int i = 0; i < ActionList.ACTIONS.size(); ++i) {
            message.limitations[i] = new ActionLimitation(config.getPermissionOf(ActionList.getByIndex(i)), config.getLeastStaminaConsumptionOf(ActionList.getByIndex(i)));
        }
        return message;
    }

    private static LimitationByServerMessage newInstance(LimitationByServer limitation) {
        LimitationByServerMessage message = new LimitationByServerMessage();
        message.forIndividuals = false;
        limitation.writeSyncData(message);
        return message;
    }

    public static void send(ServerPlayer player) {
        LimitationByServerMessage msg = LimitationByServerMessage.newInstanceForServerWide();
        msg.forIndividuals = false;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void sendIndividualLimitation(ServerPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        LimitationByServerMessage msg = LimitationByServerMessage.newInstance(parkourability.getActionInfo().getIndividualLimitation());
        msg.forIndividuals = true;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

